
local sensor = resize.location.sensor
local motor = resize.location.motor
local above_rect = Rectangle.new(motor + Vector.new(-1, 1), motor + Vector.new(1, 1))
local above_rect_left = Rectangle.new(above_rect.lesser, above_rect.lesser)
local above_rect_right = Rectangle.new(above_rect.greater, above_rect.greater)

local default_vertical = 0.6;
state:suppress_toolbar_menu();
state:suppress_transport_menu();
state:suppress_interface_hints();

set_default_vertical(default_vertical)
function wire_positions()
  local ret = {}
  for i,v in pairs(state.grid:entities()) do
    if v.type == "Wire" then
      if v.source.where == sensor then
        table.insert(ret, v.target.where)
      elseif v.target.where == sensor then
        table.insert(ret, v.source.where)
      end
    end
  end
  return ret
end
function table_contains(t, v)
  for _, x in pairs(t) do
    if x == v then
      return true
    end
  end
  return false
end
function wire_count()
  return #wire_positions()
end
function only_wire_filter(i)
  return i == PlayerInteraction.wire
end
function is_wire_open()
  local partial = state:get_partial_interaction()
  return partial.type == "PartialCreateWire"
end
function is_done()
  return wire_count() == 1
end
local function wiring_status()
  local partial = state:get_partial_interaction()
  if partial.type == "PartialCreateWire" then
    if not partial.source_set then
      if partial.source and partial.source.where == sensor and partial.source.index == 0 then
        return "source okay"
      else
        return "source bad"
      end
    else
      if partial.target and partial.target.where == motor then
        return "target okay"
      else
        return "target bad"
      end
    end
  else
    return "not wiring"
  end
end
local function wiring_interaction_filter(i)
  if i.type == "MouseEventAction" then
    if i.event == MouseEventAction.rmb_click then
      return true
    elseif i.event == MouseEventAction.lmb_click then
      local status = wiring_status()
      return status == "source okay" or status == "target okay"
    end
  elseif i.type == "MouseUpdateAction" then
    return true
  end
  return i == PlayerInteraction.cancel or i == PlayerInteraction.wire
end
local first_wire_created = false
function tutorial_routine()
  return coroutine.wrap(function()
    if not is_done() then
      set_user_input_filter(restrictive_filter)
      embed(ramp(5, do_all(
        announce_lambda("This is a piston.", 0.1),
        bouncing_arrow_at_game_lambda(Rectangle.new(motor, motor), 0.06, DOWN),
        glowing_box_at_game_lambda(Rectangle.new(motor, motor))
      ), captured_cancel()))
      embed(ramp(5, do_all(
        announce_lambda("When it receives a signal, it pushes its arm out.", 0.06),
        bouncing_arrow_at_game_lambda(above_rect_left, 0.06, UP),
        bouncing_arrow_at_game_lambda(above_rect_right, 0.06, UP),
        glowing_box_at_game_lambda(above_rect)
      ), captured_cancel()))
      embed(ramp(4, do_all(
        announce_lambda("Let's wire the piston to the sensor.", 0.08)
      ), captured_cancel()))
      embed(pause(0.2))
    end
    state:suppress_toolbar_menu(false);
    while not is_done() or is_wire_open() do
      set_user_input_filter(only_wire_filter)
      embed(ramp_until(is_wire_open, do_all(
        announce_lambda("Tool: Wire", 0.2),
        highlight_menu_item_lambda("toolbar_8")
      )))
      set_user_input_filter(wiring_interaction_filter)
      if wire_count() < 1 then
        embed(ramp_while(
          function() return wiring_status() == "source bad" or wiring_status() == "source okay" end,
          do_all(
            announce_lambda("Click on the positive sensor node to create a wire.", 0.06),
            bouncing_arrow_at_game_lambda(Rectangle.new(sensor, sensor), 0.06, RIGHT)
          )
        ))
        embed(ramp_while(
          function() return wiring_status() == "target bad" or wiring_status() == "target okay" end,
          do_all(
            announce_lambda("Click on the piston to connect a wire.", 0.06),
            announce_lambda("When a piston receives a signal, its arm moves outwards.", 0.05, default_vertical - 0.07),
            bouncing_arrow_at_game_lambda(Rectangle.new(motor, motor), 0.06, DOWN)
          )
        ))
        if not first_wire_created and wire_count() == 1 then
          first_wire_created = true
          embed(announce("This piston will now push when the sensor sees something.", 4, 0.05, captured_cancel()))
        end
      end
      if wire_count() == 1 then
        set_user_input_filter(only_play_or_cancel_filter)
        embed(ramp_while(function() return is_wire_open() and wire_count() == 1 end, do_all(
          announce_lambda("Right click far from a wire to close wiring panel.", 0.08),
          announce_lambda("(Or press Escape)", 0.06, default_vertical - 0.08)
        )))
      end
      embed(pause(0.01))
    end
    state:suppress_toolbar_menu()
    state:suppress_transport_menu(false)
    set_user_input_filter(only_play_filter)
    embed(ramp_until(
      function() return not state:is_at_start() end,
      do_all(highlight_menu_item_lambda("play_pause_button"), announce_lambda("Turn on factory", 0.15))
    ))
    set_user_input_filter(only_play_or_stop_or_speed_filter)
    embed(pause_until(function() return state.grid:ticks() >= 8 end))
    embed(announce("Success!", 3, 0.15, captured_cancel()))
  end)
end

draw_interpreted_routine(tutorial_routine())
